//
//  CRItemsManager.h
//  LightFrame
//
//  Created by Yaroslav Glushchenko on 11/11/10.
//  Copyright 2010 Corner-A. All rights reserved.
//

#import "CRLibraryItemBase.h"

//////////////////////////////////////////////////////////////////////
// CRClassDescriptor
//////////////////////////////////////////////////////////////////////
@interface CRClassDescriptor : CRLibraryItemBase
{
	NSImage*	thumbnail;
	NSString*	itemClassName;
	NSString*	detailedDescription;
}

@property (copy, nonatomic) NSImage*	thumbnail;
@property (copy, nonatomic) NSString*	itemClassName;
@property (copy, nonatomic) NSString*	detailedDescription;

- (id)initWithClass:(NSString* )className category:(NSString *)aCategory tags:(NSSet *)aTags;
- (id)initWithClass:(NSString* )className category:(NSString *)aCategory tags:(NSSet *)aTags description:(NSString *)description;
+ (id)descriptorWithClass:(NSString* )className category:(NSString *)aCategory tags:(NSSet *)aTags description:(NSString *)description;
+ (id)descriptorWithClass:(NSString* )className category:(NSString *)aCategory tags:(NSSet *)aTags;

@end

//////////////////////////////////////////////////////////////////////
// CRItemsManager singleton
//////////////////////////////////////////////////////////////////////
@interface CRItemsManager : NSObject
{
	NSArray* availableItems;
	NSArray* categories;
}

@property (strong, nonatomic, readonly) NSArray* availableItems;
@property (strong, nonatomic, readonly) NSArray* categories;

+ (id)instance;

@end